//
//  BPMViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by WiFi@ on 2018/5/18.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import "BPMViewController.h"

@interface BPMViewController () <BPMDataResponseDelegate>
@property (strong, nonatomic) BPMBLEManager *aBPMBLEManager;

@end

@implementation BPMViewController



- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.aBPMBLEManager = [BPMBLEManager shareInstanceWhithAuthorizationkey:SDKkey_BPM TargetBPMNames:@[@"A6 BT",@"A6 BASIS PLUS BT",@"A7 TOUCH BT",@"B3 BT",@"B6 Connect",@"A6",@"Progress"]];
    self.aBPMBLEManager.dataResponseDelegate = self;
    
    self.bpmBindingDevice = [self.aBPMBLEManager getBindingDevice];

}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self addLogWhitText:@"BPMBLEManager Start"];
    NSString *log = [NSString stringWithFormat:@"BPMBLEManager bpmBindingDevice:%@",self.bpmBindingDevice];
    [self addLogWhitText:log];
    [self bindingDeviceWhitMacAddres:self.bpmBindingDevice];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    // Disconnect Device
    [self.aBPMBLEManager disconnect];
    [self.aBPMBLEManager disconnectDevice];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewDidLayoutSubviews {
    self.butView.contentSize = CGSizeMake(self.butView.frame.size.width, self.butView.frame.size.height*1.75);
}

#pragma mark - IBAction
- (IBAction)getBindingDevice:(id)sender {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManager getBindingDevice:%@",[self.aBPMBLEManager getBindingDevice]];
    [self addLogWhitText:log];
}
- (IBAction)bindingDevice:(id)sender {
    [self.aBPMBLEManager bindingDevice:self.bpmBindingDevice];
    NSString *log = [NSString stringWithFormat:@"BPMBLEManager bindingDevice:%@",self.bpmBindingDevice];
    [self addLogWhitText:log];
    [self bindingDeviceWhitMacAddres:self.bpmBindingDevice];
}
- (IBAction)unBindingDevice:(id)sender {
    [self.aBPMBLEManager unBindingDevice];
    NSString *log = [NSString stringWithFormat:@"BPMBLEManager unBindingDevice:%@",[self.aBPMBLEManager getBindingDevice]];
    [self addLogWhitText:log];
}
- (IBAction)reScan:(id)sender {
    [self.aBPMBLEManager reScan];
    [self addLogWhitText:@"BPMBLEManager reScan"];
}
- (IBAction)stopScan:(id)sender {
    [self.aBPMBLEManager stopScan];
    [self addLogWhitText:@"BPMBLEManager stopScan"];
}
- (IBAction)disconnectDevice:(id)sender {
    [self.aBPMBLEManager disconnectDevice];
    [self addLogWhitText:@"BPMBLEManager disconnectDevice"];
}
- (IBAction)readHistorys:(id)sender {
    [self.aBPMBLEManager readHistorys];
    [self addLogWhitText:@"disconnectDevice readHistorys"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}
- (IBAction)clearAllHistorys:(id)sender {
    [self.aBPMBLEManager clearAllHistorys];
    [self addLogWhitText:@"BPMBLEManager clearAllHistorys"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}
- (IBAction)disconnect:(id)sender {
    [self.aBPMBLEManager disconnect];
    [self addLogWhitText:@"BPMBLEManager disconnect"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}
- (IBAction)readUserAndVersionData:(id)sender {
    [self.aBPMBLEManager readUserAndVersionData];
    [self addLogWhitText:@"BPMBLEManager readUserAndVersionData"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}
- (IBAction)writeUserData:(id)sender {
    self.currUser.age = 18+arc4random_uniform(62);
    self.currUser.BPMuserID = [self getBPMuserID];
    [self.aBPMBLEManager writeUserData:self.currUser.BPMuserID  Age:(int)self.currUser.age];
    NSString *log = [NSString stringWithFormat:@"BPMBLEManager writeUserData：%@ age：%lu",self.currUser.BPMuserID,(unsigned long)self.currUser.age];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.result];
}
- (IBAction)readPulseInfo:(id)sender {
    [self.aBPMBLEManager readLastData];
    [self addLogWhitText:@"BPMBLEManager readLastData \n[Attention] will not respond!"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}
- (IBAction)readOscillationGraph:(id)sender {
    [self.aBPMBLEManager clearLastData];
    [self addLogWhitText:@"BPMBLEManager clearLastData \n[Attention] will not respond!"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}
- (IBAction)readDeviceInfo:(id)sender {
    [self.aBPMBLEManager readDeviceInfo];
    [self addLogWhitText:@"BPMBLEManager readDeviceInfo \n[Attention] will not respond!"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}
- (IBAction)readDeviceTime:(id)sender {
    [self.aBPMBLEManager readDeviceTime];
    [self addLogWhitText:@"BPMBLEManager readDeviceTime"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}
- (IBAction)syncTiming:(id)sender {
    [self.aBPMBLEManager syncTiming];
    [self addLogWhitText:@"BPMBLEManager syncTiming"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}

#pragma mark - BPMDataResponseDelegate
- (void)BPMBLEManagerCellPhoneBluetoothDidUpdateState:(MicroLifeBLEState)state {
    if (state == MicroLifeBLEStatePoweredOn) {
        [self addLogWhitText:@"BPMBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOn"];
    }else {
        [self addLogWhitText:@"BPMBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOff"];
    }
}

- (void)BPMBLEManagerDidConnectDevice {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerDidConnectDevice:%@",self.aBPMBLEManager.bindingDevice.dictionaryFromModel];
    [self addLogWhitText:log];
}

- (void)BPMBLEManagerDidDisconnectDevice {
    [self addLogWhitText:@"BPMBLEManagerDidDisconnectDevice"];
    [self.aBPMBLEManager reScan];
}

- (void)BPMBLEManagerDidDiscoverBluetoothDeviceMacAddress:(NSData *)macAddress Name:(NSString *)name RSSI:(NSNumber *)RSSI {
    self.bpmBindingDevice = macAddress;
    [self bindingDeviceWhitMacAddres:self.bpmBindingDevice];
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerDidDiscoverBluetoothDeviceMacAddress:%@ Name:%@",macAddress,name];
    [self addLogWhitText:log];
}

- (void)BPMBLEManagerDidFailToConnectDevice {
    [self addLogWhitText:@"BPMBLEManagerDidFailToConnectDevice"];
}

- (void)BPMBLEManagerResponseClearHistory:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseClearHistory:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}

- (void)BPMBLEManagerResponseReadHistory:(MicroLifeDRecord *)data {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseReadHistory:%@",data.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}

- (void)BPMBLEManagerResponseReadLastData:(MicroLifeCurrentAndMData *)data HistoryMeasurementNumber:(int)historyMeasuremeNumber UserNumber:(int)userNumber MAMState:(int)MAMState IsNoData:(BOOL)isNoData {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseReadLastData:%@\nHistoryMeasurementNumber:%d\nUserNumber:%d\nMAMState:%d",isNoData?@"No Data":data.dictionaryFromModel,historyMeasuremeNumber,userNumber,MAMState];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}

- (void)BPMBLEManagerResponseClearLastData:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseClearLastData:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}

- (void)BPMBLEManagerResponseReadUserAndVersionData:(MicroLifeUserInfo *)user VersionData:(MicroLifeDeviceInfo *)verData {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseReadUser:%@ VersionData:%@",user.dictionaryFromModel,verData.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}

- (void)BPMBLEManagerResponseWriteUserID:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseWriteUserID:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}

- (void)BPMBLEManagerResponseReadDeviceInfo:(MicroLifeDeviceInfo *)deviceInfo {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseReadDeviceInfo:%@",deviceInfo.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}


- (void)BPMBLEManagerResponseReadDeviceTime:(MicroLifeDeviceInfo *)deviceInfo {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseReadDeviceTime:%@",deviceInfo.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}

- (void)BPMBLEManagerResponseWriteDeviceTime:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseWriteDeviceTime:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}



/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
