 //
//  OFAViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by WiFi@ on 2018/6/5.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import "OFAViewController.h"

@interface OFAViewController () <TempDataResponseDelegate,BPMDataResponseDelegate,EBodyDataResponseDelegate>

@property (strong, nonatomic) BPMBLEManager *aBPMBLEManager;
@property (strong, nonatomic) TemperatureBLEManager *aTemperatureBLEManager;
@property (strong, nonatomic) EBodyBLEManager *aEBodyBLEManager;

@end

@implementation OFAViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.aTemperatureBLEManager = [TemperatureBLEManager shareInstanceWhithAuthorizationkey:SDKkey_BT];
    self.aTemperatureBLEManager.dataResponseDelegate = self;
    
    self.aBPMBLEManager = [BPMBLEManager shareInstanceWhithAuthorizationkey:SDKkey_BPM];
    self.aBPMBLEManager.dataResponseDelegate = self;
    
    self.aEBodyBLEManager = [EBodyBLEManager shareInstanceWhithAuthorizationkey:SDKkey_WEI];
    self.aEBodyBLEManager.dataResponseDelegate = self;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self addLogWhitText:@"BLEManager Start"];
    NSString *log1 = [NSString stringWithFormat:@"TemperatureBLEManager getBindingDevice:%@",[self.aTemperatureBLEManager getBindingDevice]];
    [self addLogWhitText:log1];
    
    NSString *log2 = [NSString stringWithFormat:@"BPMBLEManager bpmBindingDevice:%@",[self.aBPMBLEManager getBindingDevice]];
    [self addLogWhitText:log2];

    NSString *log3 = [NSString stringWithFormat:@"EBodyBLEManager bpmBindingDevice:%@",[self.aEBodyBLEManager getBindingDevice]];
    [self addLogWhitText:log3];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    // Disconnect Device
    [self.aTemperatureBLEManager disconnectDevice];
    
    [self.aBPMBLEManager disconnect];
    [self.aBPMBLEManager disconnectDevice];

    [self.aEBodyBLEManager disconnectDevice];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark - TempDataResponseDelegate
- (void)TemperatureBLEManagerCellPhoneBluetoothDidUpdateState:(MicroLifeBLEState)state {
    if (state == MicroLifeBLEStatePoweredOn) {
        [self addLogWhitText:@"TemperatureBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOn"];
    }else {
        [self addLogWhitText:@"TemperatureBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOff"];
    }
}

- (void)TemperatureBLEManagerDidConnectDevice {
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManagerDidConnectDevice:%@",self.aTemperatureBLEManager.bindingDevice.dictionaryFromModel];
    [self addLogWhitText:log];
}

- (void)TemperatureBLEManagerDidDisconnectDevice {
    [self addLogWhitText:@"TemperatureBLEManagerDidDisconnectDevice"];
    [self.aTemperatureBLEManager reScan];
}

- (void)TemperatureBLEManagerDidDiscoverBluetoothDeviceMacAddress:(NSData *)macAddress Name:(NSString *)name RSSI:(NSNumber *)RSSI {
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManagerDidDiscoverBluetoothDeviceMacAddress:%@ Name:%@",macAddress,name];
    [self addLogWhitText:log];
    [self.aTemperatureBLEManager bindingDevice:macAddress];
    log = [NSString stringWithFormat:@"TemperatureBLEManager BindingDevice:%@",macAddress];
    [self addLogWhitText:log];
}

- (void)TemperatureBLEManagerDidFailToConnectDevice {
    [self addLogWhitText:@"TemperatureBLEManagerDidFailToConnectDevice"];
    [self.aTemperatureBLEManager reScan];
}

- (void)TemperatureBLEManagerResponseDeviceInfo:(NSString *)macAddress workMode:(int)workMode batteryVoltage:(float)batteryVoltage {
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManagerResponseDeviceInfo:\nmacAddress:%@\nmworkMode:%d\nbatteryVoltage:%f",macAddress,workMode,batteryVoltage];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aTemperatureBLEManager.message];
}

- (void)TemperatureBLEManagerResponseUploadMeasureData:(MicroLifeThermoMeasureData *)data {
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManagerResponseUploadMeasureData:%@",data.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aTemperatureBLEManager.message];
}

#pragma mark - BPMDataResponseDelegate
- (void)BPMBLEManagerCellPhoneBluetoothDidUpdateState:(MicroLifeBLEState)state {
    if (state == MicroLifeBLEStatePoweredOn) {
        [self addLogWhitText:@"BPMBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOn"];
    }else {
        [self addLogWhitText:@"BPMBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOff"];
    }
}

- (void)BPMBLEManagerDidConnectDevice {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerDidConnectDevice:%@",self.aBPMBLEManager.bindingDevice.dictionaryFromModel];
    [self addLogWhitText:log];
}

- (void)BPMBLEManagerDidDisconnectDevice {
    [self addLogWhitText:@"BPMBLEManagerDidDisconnectDevice"];
    [self.aBPMBLEManager reScan];
}

- (void)BPMBLEManagerDidDiscoverBluetoothDeviceMacAddress:(NSData *)macAddress Name:(NSString *)name RSSI:(NSNumber *)RSSI {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerDidDiscoverBluetoothDeviceMacAddress:%@ Name:%@",macAddress,name];
    [self addLogWhitText:log];
    [self.aBPMBLEManager bindingDevice:macAddress];
    log = [NSString stringWithFormat:@"BPMBLEManager BindingDevice:%@",macAddress];
    [self addLogWhitText:log];
}

- (void)BPMBLEManagerDidFailToConnectDevice {
    [self addLogWhitText:@"BPMBLEManagerDidFailToConnectDevice"];
    [self.aBPMBLEManager reScan];
}

- (void)BPMBLEManagerResponseClearHistory:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseClearHistory:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}

- (void)BPMBLEManagerResponseReadHistory:(MicroLifeDRecord *)data {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseReadHistory:%@",data.dictionaryFromModel];
    [self addLogWhitText:log];
    sleep(3);
    [self.aBPMBLEManager disconnect];
    [self addLogWhitText:@"BPMBLEManager disconnect"];
}

- (void)BPMBLEManagerResponseReadUserAndVersionData:(MicroLifeUserInfo *)user VersionData:(MicroLifeDeviceInfo *)verData {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseReadUser:%@ VersionData:%@",user.dictionaryFromModel,verData.dictionaryFromModel];
    [self addLogWhitText:log];
    [self uniformWork:100];
}

- (void)uniformWork:(int)work {
    work = arc4random_uniform(work);
    switch (work%3) {
        case 0:
            [self work0];
            break;
        case 1:
            [self work1];
            break;
        case 2:
            [self work2];
            break;
        default:
            break;
    }
}

- (void)work0 {
    [self.aBPMBLEManager readHistorys];
    [self addLogWhitText:@"BPMBLEManager readHistorys"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}

- (void)work1 {
    [self.aBPMBLEManager readLastData];
    [self addLogWhitText:@"BPMBLEManager readLastData"];
    [self addLogWhitText:self.aBPMBLEManager.result];
}

- (void)work2 {
    self.currUser.age = arc4random_uniform(90)+10;
    self.currUser.BPMuserID = [self getBPMuserID];
    [self.aBPMBLEManager writeUserData:self.currUser.BPMuserID  Age:(int)self.currUser.age];
    NSString *log2 = [NSString stringWithFormat:@"BPMBLEManager writeUserData:%@",self.currUser.dictionaryFromModel];
    [self addLogWhitText:log2];
    [self addLogWhitText:self.aBPMBLEManager.result];
}

- (void)BPMBLEManagerResponseWriteUserID:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseWriteUserID:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self uniformWork:2];
}

- (void)BPMBLEManagerResponseReadDeviceInfo:(MicroLifeDeviceInfo *)deviceInfo {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseReadDeviceInfo:%@",deviceInfo.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}


- (void)BPMBLEManagerResponseReadDeviceTime:(MicroLifeDeviceInfo *)deviceInfo {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseReadDeviceTime:%@",deviceInfo.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}

- (void)BPMBLEManagerResponseWriteDeviceTime:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseWriteDeviceTime:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
}

- (void)BPMBLEManagerResponseReadLastData:(MicroLifeCurrentAndMData *)data HistoryMeasurementNumber:(int)historyMeasuremeNumber UserNumber:(int)userNumber MAMState:(int)MAMState IsNoData:(BOOL)isNoData {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseReadLastData:%@\nHistoryMeasurementNumber:%d\nUserNumber:%d\nMAMState:%d",isNoData?@"No Data":data.dictionaryFromModel,historyMeasuremeNumber,userNumber,MAMState];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
    sleep(3);
    [self.aBPMBLEManager disconnect];
    [self addLogWhitText:@"BPMBLEManager disconnect"];
}

- (void)BPMBLEManagerResponseClearLastData:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"BPMBLEManagerResponseClearLastData:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aBPMBLEManager.message];
    sleep(3);
    [self.aBPMBLEManager disconnect];
    [self addLogWhitText:@"BPMBLEManager disconnect"];
}


#pragma mark - EBodyDataResponseDelegate
- (void)eBodyBLEManagerCellPhoneBluetoothDidUpdateState:(MicroLifeBLEState)state {
    if (state == MicroLifeBLEStatePoweredOn) {
        [self addLogWhitText:@"eBodyBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOn"];
    }else {
        [self addLogWhitText:@"eBodyBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOff"];
    }
}

- (void)eBodyBLEManagerDidConnectDevice {
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidConnectDevice:%@",self.aEBodyBLEManager.bindingDevice.dictionaryFromModel];
    [self addLogWhitText:log];
}

- (void)eBodyBLEManagerDidDisconnectDevice {
    [self addLogWhitText:@"eBodyBLEManagerDidDisconnectDevice"];
}

- (void)eBodyBLEManagerDidDiscoverBluetoothDeviceMacAddress:(NSData *)macAddress Name:(NSString *)name RSSI:(NSNumber *)RSSI {
    NSString *log1 = [NSString stringWithFormat:@"eBodyBLEManagerDidDiscoverBluetoothDeviceMacAddress:%@ Name:%@",macAddress,name];
    [self addLogWhitText:log1];
    [self.aEBodyBLEManager bindingDevice:macAddress];
    NSString *log2 = [NSString stringWithFormat:@"eBodyBLEManager BindingDevice:%@",macAddress];
    [self addLogWhitText:log2];
}

- (void)eBodyBLEManagerDidFailToConnectDevice {
    [self addLogWhitText:@"eBodyBLEManagerDidFailToConnectDevice"];
}

- (void)eBodyBLEManagerDidReceiveClearDataResp {
    [self addLogWhitText:@"eBodyBLEManagerDidReceiveClearDataResp"];
}

- (void)eBodyBLEManagerDidReceiveMeasureResult:(MicroLifeBodyFat *)bodyFat {
    // Update user’s weight
    self.currUser.weight = bodyFat.weight;
    // If the result of the measurement is lipid measurement, update the user's impedance value
    if (bodyFat.adiposerate > 0.001) {
        self.currUser.resistance = bodyFat.resistance;
    }
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidReceiveMeasureResult:%@",bodyFat.dictionaryFromModel];
    [self addLogWhitText:log];
}

- (void)eBodyBLEManagerDidReceiveNoMoreOfflineData {
    [self addLogWhitText:@"eBodyBLEManagerDidReceiveNoMoreOfflineData"];
}

- (void)eBodyBLEManagerDidReceiveOfflineData:(MicroLifeOfflineBodyFat *)bodyFat {
    // Not doubtful data
    if (!bodyFat.isSuspectedData) {
        // Update user’s weight
        self.currUser.weight = bodyFat.weight;
        // If the result of the measurement is lipid measurement, update the user's impedance value
        if (bodyFat.adiposerate > 0.001) {
            self.currUser.resistance = bodyFat.resistance;
        }
    }
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidReceiveOfflineData:%@",bodyFat.dictionaryFromModel];
    [self addLogWhitText:log];
}

- (void)eBodyBLEManagerDidReceiveScaleAwake {
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidReceiveScaleAwake\n%@",self.currUser.dictionaryFromModel];
    [self addLogWhitText:log];
    //After receiving the scale wake up, it needs to send user information for the user to measure
    [self.aEBodyBLEManager sendUserInfo:self.currUser];
    [self.aEBodyBLEManager sendToRequestOfflineDataWithUserInfo:self.currUser];
}

- (void)eBodyBLEManagerDidReceiveScaleSleep {
    [self addLogWhitText:@"eBodyBLEManagerDidReceiveScaleSleep"];
    
}

- (void)eBodyBLEManagerDidReceiveUpdateUserInfoResponse {
    [self addLogWhitText:@"eBodyBLEManagerDidReceiveUpdateUserInfoResponse"];
}

- (void)eBodyBLEManagerDidReceiveMeasureWeight:(float)weight unit:(MicroLifeEBUnitType)unit {
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidReceiveMeasureWeight:%f unit:%@",weight,(unit == MicroLifeEBUnitTypeKG)?@"kg":@"ld"];
    [self addLogWhitText:log];
}

@end
