//
//  RootViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by WiFi@ on 2018/5/21.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import "RootViewController.h"

@interface RootViewController ()
@property (strong, nonatomic) NSString *logStr;

@end

@implementation RootViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Do any additional setup after loading the view.
    NSString *appVersion = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleShortVersionString"];
    NSString *appBVersion = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"];
    self.VersionNumber.text = [NSString stringWithFormat:@"V %@(%@)",appVersion,appBVersion];
    
    self.MicroLifeDeviceSDKVersionNumber.text = [NSString stringWithFormat:@"DeviceSDK Version：%.1f",MicroLifeDeviceSDKVersionNumber];
    
    self.logView.editable = NO;
    self.logView.layoutManager.allowsNonContiguousLayout = NO;
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (MicroLifeUserInfo *)currUser {
    if (!_currUser) {
        MicroLifeUserInfo *user = [MicroLifeUserInfo new];
        user.EBodyuserID = [self getEBodyuserID];
        user.BPMuserID = [self getBPMuserID];
        user.UBuserID = [self getUBuserID];
        user.resistance = 0;
        user.gender = arc4random_uniform(2)?MicroLifeUserGenderFemale:MicroLifeUserGenderMale;
        user.age = 18+arc4random_uniform(62);
        user.weight = 20+arc4random_uniform(130);
        user.height = 100+arc4random_uniform(120);
        user.roleType = arc4random_uniform(2)?MicroLifeUserRoleTypeSportsman:MicroLifeUserRoleTypeNormal;
        _currUser = user;
    }
    return _currUser;
}

- (NSString *)logStr {
    if (!_logStr) {
        self.logStr = [NSString new];
    }
    return _logStr;
}

- (void)addLogWhitText:(NSString *)text {
    NSLog(@"%@",text);
    NSDateFormatter *dFormatter = [NSDateFormatter new];
    [dFormatter setLocale:[NSLocale currentLocale]];
    [dFormatter setTimeZone:[NSTimeZone systemTimeZone]];
    [dFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss:SSS"];
    NSString *date = [dFormatter stringFromDate:[NSDate date]];
    self.logStr = [self.logStr stringByAppendingFormat:@"%@\n%@\n***\n",date,text];
    self.logView.text = self.logStr;
    dispatch_async(dispatch_get_main_queue(), ^{
        [self.logView scrollRangeToVisible:NSMakeRange(0, self.logStr.length)];
    });
}

- (void)bindingDeviceWhitMacAddres:(NSData *)macAddress {
    self.bindingDevice.text = [NSString stringWithFormat:@"Did Discover Bluetooth Device：%@",macAddress];
    self.bindingDevice.adjustsFontSizeToFitWidth = YES;
}

- (NSString *)getBPMuserID {
    NSMutableString* BPMuserID = [[NSMutableString alloc] init ];
    for (int i = 0; i < 11; i++) {
        if(i < 9){
            [BPMuserID appendString:[NSString stringWithFormat:@"%d", arc4random_uniform(10)]];
        }
        else{
            NSString *str = @"QWERTYUIOPASDFGHJKLZXCVBNM";
            [BPMuserID appendString:[NSString stringWithFormat:@"%@",[str substringWithRange:NSMakeRange(arc4random_uniform(26), 1)]]];
        }
    }
    return BPMuserID;
}

- (NSString *)getEBodyuserID {
    NSMutableString* EBodyuserID = [[NSMutableString alloc] init ];
    for (int i = 0; i < 11; i++) {
        [EBodyuserID appendString:[NSString stringWithFormat:@"%d", arc4random_uniform(10)]];
    }
    return EBodyuserID;
}

- (NSString *)getUBuserID {
    NSMutableString* UBuserID = [[NSMutableString alloc] init ];
    for (int i = 0; i < 5; i++) {
        [UBuserID appendString:[NSString stringWithFormat:@"%d", arc4random_uniform(10)]];
    }
    return UBuserID;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
