//
//  TEMPViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by WiFi@ on 2018/5/21.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import "TEMPViewController.h"

@interface TEMPViewController () <TempDataResponseDelegate>

@property (strong, nonatomic) TemperatureBLEManager *aTemperatureBLEManager;


@end

@implementation TEMPViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.aTemperatureBLEManager = [TemperatureBLEManager shareInstanceWhithAuthorizationkey:SDKkey_BT];
    self.aTemperatureBLEManager.dataResponseDelegate = self;
    
    self.tempBindingDevice = [self.aTemperatureBLEManager getBindingDevice];

}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self addLogWhitText:@"TemperatureBLEManager Start"];
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManager tempBindingDevice:%@",self.tempBindingDevice];
    [self addLogWhitText:log];
    [self bindingDeviceWhitMacAddres:self.tempBindingDevice];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    // Disconnect Device
    [self.aTemperatureBLEManager disconnectDevice];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
#pragma mark - IBAction
- (IBAction)getBindingDevice:(id)sender {
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManager getBindingDevice:%@",[self.aTemperatureBLEManager getBindingDevice]];
    [self addLogWhitText:log];
}
- (IBAction)bindingDevice:(id)sender {
    [self.aTemperatureBLEManager bindingDevice:self.tempBindingDevice];
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManager BindingDevice:%@",self.tempBindingDevice];
    [self addLogWhitText:log];
    [self bindingDeviceWhitMacAddres:self.tempBindingDevice];
}
- (IBAction)unBindingDevice:(id)sender {
    [self.aTemperatureBLEManager unBindingDevice];
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManager unBindingDevice:%@",[self.aTemperatureBLEManager getBindingDevice]];
    [self addLogWhitText:log];
}
- (IBAction)reScan:(id)sender {
    [self.aTemperatureBLEManager reScan];
    [self addLogWhitText:@"TemperatureBLEManager reScan"];
}
- (IBAction)stopScan:(id)sender {
    [self.aTemperatureBLEManager stopScan];
    [self addLogWhitText:@"TemperatureBLEManager stopScan"];
}
- (IBAction)disconnectDevice:(id)sender {
    [self.aTemperatureBLEManager disconnectDevice];
    [self addLogWhitText:@"TemperatureBLEManager disconnectDevice"];
}


#pragma mark - TempDataResponseDelegate
- (void)TemperatureBLEManagerCellPhoneBluetoothDidUpdateState:(MicroLifeBLEState)state {
    if (state == MicroLifeBLEStatePoweredOn) {
        [self addLogWhitText:@"TemperatureBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOn"];
    }else {
        [self addLogWhitText:@"TemperatureBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOff"];
    }
}

- (void)TemperatureBLEManagerDidConnectDevice {
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManagerDidConnectDevice:%@",self.aTemperatureBLEManager.bindingDevice.dictionaryFromModel];
    [self addLogWhitText:log];
}

- (void)TemperatureBLEManagerDidDisconnectDevice {
    [self addLogWhitText:@"TemperatureBLEManagerDidDisconnectDevice"];
    [self.aTemperatureBLEManager reScan];
}

- (void)TemperatureBLEManagerDidDiscoverBluetoothDeviceMacAddress:(NSData *)macAddress Name:(NSString *)name RSSI:(NSNumber *)RSSI {
    self.tempBindingDevice = macAddress;
    [self bindingDeviceWhitMacAddres:self.tempBindingDevice];
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManagerDidDiscoverBluetoothDeviceMacAddress:%@ Name:%@",macAddress,name];
    [self addLogWhitText:log];
}

- (void)TemperatureBLEManagerDidFailToConnectDevice {
    [self addLogWhitText:@"TemperatureBLEManagerDidFailToConnectDevice"];
}

- (void)TemperatureBLEManagerResponseDeviceInfo:(NSString *)macAddress workMode:(int)workMode batteryVoltage:(float)batteryVoltage {
    [self addLogWhitText:self.aTemperatureBLEManager.result];
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManagerResponseDeviceInfo:\nmacAddress:%@\nmworkMode:%d\nbatteryVoltage:%f",macAddress,workMode,batteryVoltage];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aTemperatureBLEManager.message];
}

- (void)TemperatureBLEManagerResponseUploadMeasureData:(MicroLifeThermoMeasureData *)data {
    [self addLogWhitText:self.aTemperatureBLEManager.result];
    NSString *log = [NSString stringWithFormat:@"TemperatureBLEManagerResponseUploadMeasureData:%@",data.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aTemperatureBLEManager.message];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
