//
//  WBPViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by willy.wu on 2019/4/15.
//  Copyright © 2019 WiFi@MBP. All rights reserved.
//

#import "WBPViewController.h"

@interface WBPViewController () <WBPDataResponseDelegate>
@property (strong, nonatomic) WBPBLEManager *aWBPBLEManager;

@end

@interface WBPViewController ()

@end

@implementation WBPViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.aWBPBLEManager = [WBPBLEManager shareInstanceWhithAuthorizationkey:SDKkey_WBP];
    self.aWBPBLEManager.dataResponseDelegate = self;
    
    self.wbpBindingDevice = [self.aWBPBLEManager getBindingDevice];
    
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self addLogWhitText:@"WBPBLEManager Start"];
    NSString *log = [NSString stringWithFormat:@"WBPBLEManager bpmBindingDevice:%@",self.wbpBindingDevice];
    [self addLogWhitText:log];
    [self bindingDeviceWhitMacAddres:self.wbpBindingDevice];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    // Disconnect Device
    [self.aWBPBLEManager disconnectDevice];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewDidLayoutSubviews {
    self.butView.contentSize = CGSizeMake(self.butView.frame.size.width, self.butView.frame.size.height*2);
}

#pragma mark - IBAction
- (IBAction)getBindingDevice:(id)sender {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManager getBindingDevice:%@",[self.aWBPBLEManager getBindingDevice]];
    [self addLogWhitText:log];
}
- (IBAction)bindingDevice:(id)sender {
    [self.aWBPBLEManager bindingDevice:self.wbpBindingDevice];
    NSString *log = [NSString stringWithFormat:@"WBPBLEManager bindingDevice:%@",self.wbpBindingDevice];
    [self addLogWhitText:log];
    [self bindingDeviceWhitMacAddres:self.wbpBindingDevice];
}
- (IBAction)unBindingDevice:(id)sender {
    [self.aWBPBLEManager unBindingDevice];
    NSString *log = [NSString stringWithFormat:@"WBPBLEManager unBindingDevice:%@",[self.aWBPBLEManager getBindingDevice]];
    [self addLogWhitText:log];
}
- (IBAction)reScan:(id)sender {
    [self.aWBPBLEManager reScan];
    [self addLogWhitText:@"WBPBLEManager reScan"];
}
- (IBAction)stopScan:(id)sender {
    [self.aWBPBLEManager stopScan];
    [self addLogWhitText:@"WBPBLEManager stopScan"];
}
- (IBAction)disconnectDevice:(id)sender {
    [self.aWBPBLEManager disconnectDevice];
    [self addLogWhitText:@"WBPBLEManager disconnectDevice"];
}
- (IBAction)comAction:(UIButton *)sender {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManager %@",sender.titleLabel.text];
    switch ([sender tag]) {
        case 100:
            [self.aWBPBLEManager readUsualModeHistoryData];
            break;
        case 101:
            [self.aWBPBLEManager readDiagnosticModeHistoryData];
            break;
        case 102:
        {
            BOOL usualMode = arc4random_uniform(2);
            BOOL diagnosticMode = arc4random_uniform(2);
            BOOL nocturnalMode = arc4random_uniform(2);
            [self.aWBPBLEManager clearHistoryDataWithSelectedUsualMode:usualMode DiagnosticMode:diagnosticMode NocturnalMode:nocturnalMode];
            log = [log stringByAppendingFormat:@"Selected >> UsualMode:%@ DiagnosticMode:%@ NocturnalMode:%@",usualMode?@"YES":@"NO",diagnosticMode?@"YES":@"NO",nocturnalMode?@"YES":@"NO"];
        }
            break;
        case 103:
            [self.aWBPBLEManager clearCurrentModeHistoryData];
            break;
        case 104:
            [self.aWBPBLEManager disconnect];
            break;
        case 105:
            [self.aWBPBLEManager writeDeviceTime];
            break;
        case 106:
            [self.aWBPBLEManager writeUserID:self.currUser.BPMuserID];
            log = [log stringByAppendingFormat:@"：%@",self.currUser.BPMuserID];
            break;
        case 110:
            [self.aWBPBLEManager readDeviceIDAndInfo];
            break;
        case 111:
            [self.aWBPBLEManager readDeviceTime];
            break;
        case 112:
            [self.aWBPBLEManager readUserAndVersionData];
            break;
        default:
            break;
    }
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.result];
}

#pragma mark - WBPDataResponseDelegate
- (void)WBPBLEManagerCellPhoneBluetoothDidUpdateState:(MicroLifeBLEState)state {
    if (state == MicroLifeBLEStatePoweredOn) {
        [self addLogWhitText:@"WBPBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOn"];
    }else {
        [self addLogWhitText:@"WBPBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOff"];
    }
}

- (void)WBPBLEManagerDidConnectDevice {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerDidConnectDevice:%@",self.aWBPBLEManager.bindingDevice.dictionaryFromModel];
    [self addLogWhitText:log];
}

- (void)WBPBLEManagerDidDisconnectDevice {
    [self addLogWhitText:@"WBPBLEManagerDidDisconnectDevice"];
    [self.aWBPBLEManager reScan];
}

- (void)WBPBLEManagerDidDiscoverBluetoothDeviceMacAddress:(NSData *)macAddress Name:(NSString *)name RSSI:(NSNumber *)RSSI {
    self.wbpBindingDevice = macAddress;
    [self bindingDeviceWhitMacAddres:self.wbpBindingDevice];
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerDidDiscoverBluetoothDeviceMacAddress:%@ Name:%@",macAddress,name];
    [self addLogWhitText:log];
}

- (void)WBPBLEManagerDidFailToConnectDevice {
    [self addLogWhitText:@"WBPBLEManagerDidFailToConnectDevice"];
}

- (void)WBPBLEManagerResponseReadUsualModeHistoryData:(MicroLifeDRecord *)data IsNoData:(BOOL)isNoData {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseReadUsualModeHistoryData:%@",isNoData?@"No Data":data.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}

- (void)WBPBLEManagerResponseClearCurrentModeHistoryData:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseClearCurrentModeHistoryData:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}

- (void)WBPBLEManagerResponseClearSelectedModeHistoryData:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseClearSelectedModeHistoryData:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}

- (void)WBPBLEManagerResponseReadDeviceIDAndInfo:(nonnull MicroLifeDeviceInfo *)deviceInfo {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseReadDeviceIDAndInfo:%@",deviceInfo.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}

- (void)WBPBLEManagerResponseReadDeviceTime:(nonnull MicroLifeDeviceInfo *)deviceInfo {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseReadDeviceTime:%@",deviceInfo.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}

- (void)WBPBLEManagerResponseReadDiagnosticModeHistoryData:(nonnull MicroLifeDiagnosticDRecord *)data IsNoData:(BOOL)isNoData {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseReadDiagnosticModeHistoryData:%@",isNoData?@"No Data":data.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}

- (void)WBPBLEManagerResponseReadUserAndVersionData:(nonnull MicroLifeUserInfo *)user VersionData:(nonnull MicroLifeDeviceInfo *)verData {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseReadUserAndVersionData:%@ VersionData:%@",user.dictionaryFromModel,verData.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}

- (void)WBPBLEManagerResponseWriteDeviceTime:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseWriteDeviceTime:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}

- (void)WBPBLEManagerResponseWriteUserID:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseWriteUserID:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}

- (void)WBPBLEManagerResponseChangeNocturnalModeSetting:(BOOL)isSuccess {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseWriteUserID:%@",isSuccess?@"YES":@"NO"];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}


- (void)WBPBLEManagerResponseReadNocturnalModeSetting:(nonnull MicroLifeDeviceInfo *)deviceInfo {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseReadNocturnalModeSetting:%@",deviceInfo.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}


- (void)WBPBLEManagerResponseReadNocturnalPatternHistoryData:(nonnull MicroLifeNocturnalModeDRecord *)data IsNoData:(BOOL)isNoData {
    NSString *log = [NSString stringWithFormat:@"WBPBLEManagerResponseReadNocturnalPatternHistoryData:%@",isNoData?@"No Data":data.dictionaryFromModel];
    [self addLogWhitText:log];
    [self addLogWhitText:self.aWBPBLEManager.message];
}

@end
