//
//  WEIViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by WiFi@ on 2018/5/18.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import "WEIViewController.h"

@interface WEIViewController () <EBodyDataResponseDelegate>
@property (strong, nonatomic) EBodyBLEManager *aEBodyBLEManager;

@end

@implementation WEIViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.aEBodyBLEManager = [EBodyBLEManager shareInstanceWhithAuthorizationkey:SDKkey_WEI];
    self.aEBodyBLEManager.dataResponseDelegate = self;
    
    self.weipBindingDevice = [self.aEBodyBLEManager getBindingDevice];

}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self addLogWhitText:@"EBodyBLEManager Start"];
    NSString *log = [NSString stringWithFormat:@"EBodyBLEManager weipBindingDevice:%@",self.weipBindingDevice];
    [self addLogWhitText:log];
    [self bindingDeviceWhitMacAddres:self.weipBindingDevice];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    // Disconnect Device
    [self.aEBodyBLEManager disconnectDevice];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - IBAction
- (IBAction)getBindingDevice:(id)sender {
    NSString *log = [NSString stringWithFormat:@"EBodyBLEManager getBindingDevice:%@",[self.aEBodyBLEManager getBindingDevice]];
    [self addLogWhitText:log];
}
- (IBAction)bindingDevice:(id)sender {
    [self.aEBodyBLEManager bindingDevice:self.weipBindingDevice];
    NSString *log = [NSString stringWithFormat:@"EBodyBLEManager bindingDevice:%@",self.weipBindingDevice];
    [self addLogWhitText:log];
    [self bindingDeviceWhitMacAddres:self.weipBindingDevice];
}
- (IBAction)unBindingDevice:(id)sender {
    [self.aEBodyBLEManager unBindingDevice];
    NSString *log = [NSString stringWithFormat:@"EBodyBLEManager unBindingDevice:%@",[self.aEBodyBLEManager getBindingDevice]];
    [self addLogWhitText:log];
}
- (IBAction)reScan:(id)sender {
    [self.aEBodyBLEManager reScan];
    [self addLogWhitText:@"EBodyBLEManager reScan"];
}
- (IBAction)stopScan:(id)sender {
    [self.aEBodyBLEManager stopScan];
    [self addLogWhitText:@"EBodyBLEManager stopScan"];
}
- (IBAction)disconnectDevice:(id)sender {
    [self.aEBodyBLEManager disconnectDevice];
    [self addLogWhitText:@"EBodyBLEManager disconnectDevice"];
}
- (IBAction)sendUserInfo:(id)sender {
    self.currUser.EBodyuserID = [self getEBodyuserID];
    [self.aEBodyBLEManager sendUserInfo:self.currUser];
    NSString *log = [NSString stringWithFormat:@"EBodyBLEManager sendUserInfo: %@",self.currUser.dictionaryFromModel];
    [self addLogWhitText:log];
}
- (IBAction)sendToClearAllUsers:(id)sender {
    [self.aEBodyBLEManager sendToClearAllUsers];
    [self addLogWhitText:@"EBodyBLEManager sendToClearAllUsers"];

}
- (IBAction)sendToRequestOfflineDataWithUserInfo:(id)sender {
    [self.aEBodyBLEManager sendToRequestOfflineDataWithUserInfo:self.currUser];
    NSString *log = [NSString stringWithFormat:@"EBodyBLEManager sendToRequestOfflineDataWithUserInfo:%@",self.currUser.dictionaryFromModel];
    [self addLogWhitText:log];
}

#pragma mark - EBodyDataResponseDelegate
- (void)eBodyBLEManagerCellPhoneBluetoothDidUpdateState:(MicroLifeBLEState)state {
    if (state == MicroLifeBLEStatePoweredOn) {
        [self addLogWhitText:@"eBodyBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOn"];
    }else {
        [self addLogWhitText:@"eBodyBLEManagerCellPhoneBluetoothDidUpdateState:MicroLifeBLEStatePoweredOff"];
    }
}

- (void)eBodyBLEManagerDidConnectDevice {
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidConnectDevice:%@",self.aEBodyBLEManager.bindingDevice.dictionaryFromModel];
    [self addLogWhitText:log];
}

- (void)eBodyBLEManagerDidDisconnectDevice {
    NSLog(@"eBodyBLEManagerDidDisconnectDevice");
    [self addLogWhitText:@"eBodyBLEManagerDidDisconnectDevice"];
    [self.aEBodyBLEManager reScan];
}

- (void)eBodyBLEManagerDidDiscoverBluetoothDeviceMacAddress:(NSData *)macAddress Name:(NSString *)name RSSI:(NSNumber *)RSSI {
    self.weipBindingDevice = macAddress;
    [self bindingDeviceWhitMacAddres:self.weipBindingDevice];
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidDiscoverBluetoothDeviceMacAddress:%@ Name:%@",macAddress,name];
    [self addLogWhitText:log];
}

- (void)eBodyBLEManagerDidFailToConnectDevice {
    NSLog(@"eBodyBLEManagerDidFailToConnectDevice");
    [self addLogWhitText:@"eBodyBLEManagerDidFailToConnectDevice"];

}

- (void)eBodyBLEManagerDidReceiveClearDataResp {
    [self addLogWhitText:@"eBodyBLEManagerDidReceiveClearDataResp"];

}

- (void)eBodyBLEManagerDidReceiveMeasureResult:(MicroLifeBodyFat *)bodyFat {
    // Update user’s weight
    self.currUser.weight = bodyFat.weight;
    // If the result of the measurement is lipid measurement, update the user's impedance value
    if (bodyFat.adiposerate > 0.001) {
        self.currUser.resistance = bodyFat.resistance;
    }
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidReceiveMeasureResult:%@",bodyFat.dictionaryFromModel];
    [self addLogWhitText:log];}

- (void)eBodyBLEManagerDidReceiveNoMoreOfflineData {
    [self addLogWhitText:@"eBodyBLEManagerDidReceiveNoMoreOfflineData"];
}

- (void)eBodyBLEManagerDidReceiveOfflineData:(MicroLifeOfflineBodyFat *)bodyFat {
    // Not doubtful data
    if (!bodyFat.isSuspectedData) {
        // Update user’s weight
        self.currUser.weight = bodyFat.weight;
        // If the result of the measurement is lipid measurement, update the user's impedance value
        if (bodyFat.adiposerate > 0.001) {
            self.currUser.resistance = bodyFat.resistance;
        }
    }
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidReceiveOfflineData:%@",bodyFat.dictionaryFromModel];
    [self addLogWhitText:log];
}

- (void)eBodyBLEManagerDidReceiveScaleAwake {
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidReceiveScaleAwake\n%@",self.currUser.dictionaryFromModel];
    [self addLogWhitText:log];
    //After receiving the scale wake up, it needs to send user information for the user to measure
    [self.aEBodyBLEManager sendUserInfo:self.currUser];
}

- (void)eBodyBLEManagerDidReceiveScaleSleep {
    [self addLogWhitText:@"eBodyBLEManagerDidReceiveScaleSleep"];

}

- (void)eBodyBLEManagerDidReceiveUpdateUserInfoResponse {
    [self addLogWhitText:@"eBodyBLEManagerDidReceiveUpdateUserInfoResponse"];
}

- (void)eBodyBLEManagerDidReceiveMeasureWeight:(float)weight unit:(MicroLifeEBUnitType)unit {
    NSString *log = [NSString stringWithFormat:@"eBodyBLEManagerDidReceiveMeasureWeight:%f unit:%@",weight,(unit == MicroLifeEBUnitTypeKG)?@"kg":@"ld"];
    [self addLogWhitText:log];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
