//
//  BPMBLEManager.h
//  MicroLifeDeviceSDK
//
//  Created by WiFi@ on 2018/4/13.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MicroLifeDeviceSDK.h"
#import "MicroLifeDevice.h"
#import "MicroLifeUserInfo.h"
#import "MicroLifeDeviceInfo.h"
#import "MicroLifeDRecord.h"
#import "MicroLifeCurrentAndMData.h"
#import "MicroLifePulseInfo.h"
#import "MicroLifePulseRecord.h"
#import "MicroLifeOscillationData.h"

@protocol BPMDataResponseDelegate
#pragma mark - Bluetooth connection section
/**
 Mobile phone Bluetooth status changes
 
 @param state Mobile phone Bluetooth status
 */
- (void)BPMBLEManagerCellPhoneBluetoothDidUpdateState:(MicroLifeBLEState)state;

/**
 Search to device
 
 @param macAddress macAddress
 @param name name
 @param RSSI RSSI
 */
- (void)BPMBLEManagerDidDiscoverBluetoothDeviceMacAddress:(NSData *)macAddress Name:(NSString *)name RSSI:(NSNumber *)RSSI;

/**
 Device is connected
 */
- (void)BPMBLEManagerDidConnectDevice;

/**
 Device connection failed
 */
- (void)BPMBLEManagerDidFailToConnectDevice;

/**
 Disconnect
 */
- (void)BPMBLEManagerDidDisconnectDevice;

#pragma mark - Received data section
/**
 Read History

 @param data History Data
 */
- (void)BPMBLEManagerResponseReadHistory:(MicroLifeDRecord *)data;

/**
 Clear History

 @param isSuccess Success
 */
- (void)BPMBLEManagerResponseClearHistory:(BOOL)isSuccess;

/**
 Read UserInfo And DeviceInfo

 @param user UserInfo
 @param verData DeviceInfo
 */
- (void)BPMBLEManagerResponseReadUserAndVersionData:(MicroLifeUserInfo *)user VersionData:(MicroLifeDeviceInfo *)verData;

/**
 Read last 1 data of the BPM

 @param data last 1 data
 @param historyMeasuremeNumber History Measurement Number: The range of Memory Set = 0~255
 @param userNumber User Number : User1 = 1, User2 = 2, Guest = 3
 @param MAMState MAM state : 0=MAM disable, 1=Weight off, 2=Weight on, 3=Light off, 4=Light on.
 @param isNoData is No Data
 */
- (void)BPMBLEManagerResponseReadLastData:(MicroLifeCurrentAndMData *)data HistoryMeasurementNumber:(int)historyMeasuremeNumber UserNumber:(int)userNumber MAMState:(int)MAMState IsNoData:(BOOL)isNoData;

/**
 Clear last 1 data of the BPM

 @param isSuccess Success
 */
- (void)BPMBLEManagerResponseClearLastData:(BOOL)isSuccess;

/**
 Write UserID

 @param isSuccess Success
 */
- (void)BPMBLEManagerResponseWriteUserID:(BOOL)isSuccess;

/**
 Return device information

 @param deviceInfo device information
 */
- (void)BPMBLEManagerResponseReadDeviceInfo:(MicroLifeDeviceInfo *)deviceInfo;

/**
 Return device time information
 
 @param deviceInfo device time information
 */
- (void)BPMBLEManagerResponseReadDeviceTime:(MicroLifeDeviceInfo *)deviceInfo;

/**
 Write Device Time

 @param isSuccess Success
 */
- (void)BPMBLEManagerResponseWriteDeviceTime:(BOOL)isSuccess;
@end

@interface BPMBLEManager : NSObject 
@property (nonatomic, weak) id<BPMDataResponseDelegate> dataResponseDelegate;
@property (nonatomic, strong) MicroLifeDevice *bindingDevice;

@property (nonatomic, strong) NSString *result;
@property (nonatomic, strong) NSString *message;

/**
 Singleton Construction Bluetooth Controller Open equipment:"A6 BT","A6 BASIS PLUS BT","A7 TOUCH BT","B3 BT","B6 Connect","A6","Progress"
 
 @param key Authorization key
 @return Bluetooth Controller
 */
+ (instancetype)shareInstanceWhithAuthorizationkey:(NSString *)key;

/**
 Singleton Construction Bluetooth Controller

 @param key Authorization key
 @param targetBPMNames Set the specified display Bluetooth device name
 @return Bluetooth Controller
 */
+ (instancetype)shareInstanceWhithAuthorizationkey:(NSString *)key TargetBPMNames:(NSArray *)targetBPMNames;

#pragma mark - Send
/**
 read all history or current data from bpm
 */
-(void)readHistorys;

/**
 clear all history data from bpm
 */
- (void)clearAllHistorys;

/**
 disconnect
 */
- (void)disconnect;

/**
 read user id and version data from bpm
 */
- (void)readUserAndVersionData;

/**
 write a new user id & age
 
 @param ID userID
 @param age age
 */
-(void)writeUserData:(NSString*)ID Age:(int)age;

/**
 [3G Dedicated] Read last 1 data from the BPM
 
 [Attention] will not respond!
 */
- (void)readLastData;

/**
 [3G Dedicated] Clear last 1 data of the BPM
 
 [Attention] will not respond!
 */
- (void)clearLastData;

/**
 read Device information
 */
- (void)readDeviceInfo;

/**
 [4G Dedicated] Read device Time from BPM
 */
- (void)readDeviceTime;

/**
 [4G Dedicated] Synchronize device time 
 */
- (void)syncTiming;

#pragma mark - Feature
/**
 Get the MAC address of the currently bound scale
 
 @return Mac address, if no device is bound, return nil
 */
- (NSData *)getBindingDevice;

/**
 Binding device
 
 @param macAddress Target device's Mac address
 */
- (void)bindingDevice:(NSData *)macAddress;

/**
   Untie equipment
   */
- (void)unBindingDevice;

#pragma mark - Bluetooth connection
/**
 Re-search for device
 
 */
- (void)reScan;

/**
 Stop searching for device
 */
- (void)stopScan;

/**
   Disconnect Bluetooth from the current device
   */
- (void)disconnectDevice;

@end
