//
//  EBodyBLEManager.h
//  MicroLifeDeviceSDK
//
//  Created by WiFi@ on 2018/4/13.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MicroLifeDeviceSDK.h"
#import "MicroLifeDevice.h"
#import "MicroLifeUserInfo.h"
#import "MicroLifeDeviceInfo.h"
#import "MicroLifeBodyFat.h"
#import "MicroLifeOfflineBodyFat.h"

@protocol EBodyDataResponseDelegate
#pragma mark - Bluetooth connection section
/**
 Mobile phone Bluetooth status changes

 @param state Mobile phone Bluetooth status
 */
- (void)eBodyBLEManagerCellPhoneBluetoothDidUpdateState:(MicroLifeBLEState)state;

/**
 Search to device

 @param macAddress macAddress
 @param name name
 @param RSSI RSSI
 */
- (void)eBodyBLEManagerDidDiscoverBluetoothDeviceMacAddress:(NSData *)macAddress Name:(NSString *)name RSSI:(NSNumber *)RSSI;
/**
 Device is connected
 */
- (void)eBodyBLEManagerDidConnectDevice;

/**
 Device connection failed
 */
- (void)eBodyBLEManagerDidFailToConnectDevice;

/**
 Disconnect
 */
- (void)eBodyBLEManagerDidDisconnectDevice;

#pragma mark - Received data section
/**
 Received scale is awakened (scale screen bright screen)
 */
- (void)eBodyBLEManagerDidReceiveScaleAwake;

/**
 Receive the scale to go to sleep (scale screen)
 */
- (void)eBodyBLEManagerDidReceiveScaleSleep;

/**
 Received user information update response
 Note: The SDK will also send user information to the scale internally, so you may receive this callback frequently.
 */
- (void)eBodyBLEManagerDidReceiveUpdateUserInfoResponse;

/**
 Received the current measurement result data
 */
- (void)eBodyBLEManagerDidReceiveMeasureResult:(MicroLifeBodyFat *)bodyFat;

/**
 Received the current measured weight (will be received before the full measurement is received)

 @param weight measured weight
 @param unit measured weight unit
 */
- (void)eBodyBLEManagerDidReceiveMeasureWeight:(float)weight unit:(MicroLifeEBUnitType)unit;

/**
 Received offline data
 */
- (void)eBodyBLEManagerDidReceiveOfflineData:(MicroLifeOfflineBodyFat *)bodyFat;

/**
 Received no more offline data instructions
 */
- (void)eBodyBLEManagerDidReceiveNoMoreOfflineData;

/**
 Received all user responses cleared
 */
- (void)eBodyBLEManagerDidReceiveClearDataResp;

@end

@interface EBodyBLEManager : NSObject
@property (nonatomic, weak) id<EBodyDataResponseDelegate> dataResponseDelegate;
@property (nonatomic, strong) MicroLifeDevice *bindingDevice;

/**
 Singleton Construction Bluetooth Controller


 @param key Authorization key
 @return Bluetooth Controller
 */
+ (instancetype)shareInstanceWhithAuthorizationkey:(NSString *)key;

#pragma mark Send
/**
 Send User information

 @param userInfo User information model
 */
- (void)sendUserInfo:(MicroLifeUserInfo *)userInfo;

/**
 Clear All Users
 */
- (void)sendToClearAllUsers;

/**
 Send inquiry offline record
 */
- (void)sendToRequestOfflineDataWithUserInfo:(MicroLifeUserInfo *)userInfo;

#pragma mark Feature
/**
 Get the MAC address of the currently bound scale

 @return Mac address, if no device is bound, return nil
 */
- (NSData *)getBindingDevice;

/**
 Binding device
 
 @param macAddress Target device's Mac address
 */
- (void)bindingDevice:(NSData *)macAddress;

/**
   Untie equipment
   */
- (void)unBindingDevice;

#pragma mark Bluetooth connection
/**
 Re-search for device
 
 */
- (void)reScan;

/**
 Stop searching for device
 */
- (void)stopScan;

/**
   Disconnect Bluetooth from the current device
   */
- (void)disconnectDevice;

@end
