//
//  MicroLifeBodyFat.h
//  MicroLifeDeviceSDK
//
//  Created by WiFi@ on 2018/4/13.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

/**
 Weight unit (kg/lb)

 - MicroLifeEBUnitTypeKG: kg
 - MicroLifeEBUnitTypeLB: lb
 */
typedef NS_ENUM(NSInteger, MicroLifeEBUnitType) {
    MicroLifeEBUnitTypeKG,
    MicroLifeEBUnitTypeLB,
};

@interface MicroLifeBodyFat : NSObject

/**
 * measure time
 */
@property (nonatomic,strong) NSString *time;

/**
 * Measured member ID
 */
@property (nonatomic,copy) NSString *userId;

/**
 * Weight unit (kg/lb)
 */
@property (nonatomic,assign) MicroLifeEBUnitType unit;

/**
 * Weight
 * Unit: kg
 */
@property (nonatomic,assign) CGFloat weight;

/**
 * bone amount
 * Unit: kg
 */
@property (nonatomic,assign) CGFloat bone;

/**
 * Fat rate
 * Unit: %
 */
@property (nonatomic,assign) CGFloat adiposerate;

/**
 * Visceral fat level
 */
@property (nonatomic,assign) CGFloat visceralfat;

/**
 * Moisture rate
 * Unit: %
 */
@property (nonatomic,assign) CGFloat moisture;

/**
 * Basal metabolic rate
 * Unit: kcal/d
 */
@property (nonatomic,assign) CGFloat bmr;

/**
 * BMI
 */
@property (nonatomic,assign) CGFloat bmi;

/**
 * Body impedance
 */
@property (nonatomic,assign) NSUInteger resistance;

/**
 * Protein
 * Unit: %
 */
@property (nonatomic,assign) CGFloat protein;

/**
 * skeletal muscle
 * Unit: kg
 */
@property (nonatomic,assign) CGFloat boneMuscle;

@end
