//
//  MicroLifeCurrentAndMData.h
//  MicroLifeDeviceSDK
//
//  Created by WiFi@ on 2018/4/19.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface MicroLifeCurrentAndMData : NSObject

/**
 Systolic
 */
@property (nonatomic,assign) int sys;

/**
 Diastolic
 */
@property (nonatomic,assign) int dia;

/**
 Pulse
 */
@property (nonatomic,assign) int hr;

/**
 Year
 */
@property (nonatomic,assign) int year;

/**
 Month
 */
@property (nonatomic,assign) int month;

/**
 Date
 */
@property (nonatomic,assign) int day;

/**
 Hour
 */
@property (nonatomic,assign) int hour;

/**
 Minte
 */
@property (nonatomic,assign) int minute;

/**
 3G detection mode 0:BP_Single_MOD 3:BP_MAM_MODE+ SW AFib ON
 4G detection mode 0:BP_Single_MOD 1:BP_Single_MODE+SW AFib ON 2:BP_MAM_MODE 3:BP_MAM_MODE+ SW AFib ON
 */
@property (nonatomic,assign) int MAM;

/**
 the data detect with PAD  or Afib
 */
@property (nonatomic,assign) BOOL arr;

//4G
/**
 Whether the wristband is tight
 3G detection mode 2: No detection
 4G detection mode 0: No tightness 1: There is tightness
 */
@property (nonatomic,assign) int cuffokr;

/**
 IHB
 */
@property (nonatomic,assign) BOOL IHB;

/**
 AFIb (If both detect Afib and IHB, only display Afib)
 */
@property (nonatomic,assign) BOOL AFIb;

//WBP
/**
 the data is measured in usual mode
 */
@property (nonatomic,assign) BOOL usual;

/**
 the data is measured in diagnostic mode
 */
@property (nonatomic,assign) BOOL diagnostic;

/**
 the data is measured in night with diagnostic mode (ex. 4:00~12:00)
 */
@property (nonatomic,assign) BOOL AM;

/**
 the data is measured in morning with diagnostic mode (ex. 18:00~24:00)
 */
@property (nonatomic,assign) BOOL PM;

//Data Form
/**
 isFor3G (Data is Form 3G)
 */
@property (nonatomic,assign) BOOL isFor3G;

/**
 deviceMode (Data is Form Device)
 Device     Description
 0x31    3G BPM
 0x3A    4G BPM
 0x51    WBP HomeA
 */
@property (nonatomic,assign) int deviceMode;

/**
 Result Code     Error Message    Description
 0x01            Error 1          Signals is too weak
 0x02            Error 2          Error signal
 0x03            Error 3          No pressure in the cuff
 0x05            Error 5          Abnormal result
 0x42            Error B          Low battery
 0x50            Error P          Manual stop measurement.
 0x51            Error Q          Busy
 0x52            Error R          Past time
 */
@property (nonatomic,assign) int resultCode;

/**
 Result Code     Error Message    Description
 0x01            Error 1          Signals is too weak
 0x02            Error 2          Error signal
 0x03            Error 3          No pressure in the cuff
 0x05            Error 5          Abnormal result
 0x42            Error B          Low battery
 0x50            Error P          Manual stop measurement.
 0x51            Error Q          Busy
 0x52            Error R          Past time
 */
@property (nonatomic,strong) NSString *errorMessage;

+ (instancetype)initWithData:(NSString *)data Origin:(int)origin;

@end
