//
//  MicroLifeDRecord.h
//  MicroLifeDeviceSDK
//  
//  Created by WiFi@ on 2018/4/19.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface MicroLifeDRecord : NSObject

/**
 Mode:Thevalueofthisflagisfixedto0x00
 */
@property (nonatomic,assign) int mode;

/**
 CurrentMode:
 0: BP_Single_MODE
 1: BP_Single_MODE + SW Afib ON 2: BP_MAM_MODE
 3: BP_MAM_MODE + SW Afib ON
 */
@property (nonatomic,assign) int noOfCurrentMeasurement;

/**
 History Measurement times:
 PUBLIC COMMUNICATION SPECIFICATION FOR BLE /USB
 The history measurement times store in memory.
 */
@property (nonatomic,assign) int historyMeasuremeNumber;

/**
 UserNumber:User1=1,User2=2,Guest=3
 */
@property (nonatomic,assign) int userNumber;

/**
 MAMversion:0x00=MAMweight,0x01=MAMlight,0Xff=NoMAMfunction.
 The MAM result is calculated by simple arithmetic mean (MAM light) or weighted mean (MAM weight).
 */
@property (nonatomic,assign) int MAMState;

/**
 All blood pressure menasurement data
 */
@property (nonatomic,strong) NSMutableArray *MData;

/**
 Newest blood pressure measurement data[Reserved]
 */
@property (nonatomic,strong) NSMutableArray *currentData;

+ (instancetype)initWithData:(NSString *)data Origin:(int)origin;

@end
