//
//  MicroLifeDeviceInfo.h
//  MicroLifeDeviceSDK
//  
//  Created by WiFi@ on 2018/4/19.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface MicroLifeDeviceInfo : NSObject

#pragma mark - VersionData

@property (nonatomic,assign) NSInteger year;

@property (nonatomic,assign) NSInteger month;

@property (nonatomic,assign) NSInteger day;

@property (nonatomic,assign) NSInteger hour;

@property (nonatomic,assign) NSInteger minute;

@property (nonatomic,assign) NSInteger second;

@property (nonatomic,assign) NSInteger maxUser;

@property (nonatomic,assign) NSUInteger maxMemory;

@property (nonatomic,assign) BOOL optionIHB;

@property (nonatomic,assign) BOOL optionAfib;

@property (nonatomic,assign) BOOL optionMAM;

@property (nonatomic,assign) BOOL optionAmbientT;

@property (nonatomic,assign) BOOL optionTubeless;

@property (nonatomic,assign) BOOL optionDeviceID;

@property (nonatomic,assign) double deviceBatteryVoltage;

@property (nonatomic,strong) NSString *FWName;

@property (nonatomic,strong) NSString *macAddress;

@property (nonatomic,strong) NSString *connectType;

@property (nonatomic,assign) int measurementTimes;

@property (nonatomic,strong) NSMutableArray *errHappendTimes;

@property (nonatomic,assign) BOOL isTimeReady;

@property (nonatomic,assign) BOOL openNocturnal;

@property (nonatomic,assign) BOOL optionDiagnosticModeAFib;

@property (nonatomic,assign) BOOL openNoUsualModeAFib;

/**
 Can change the night mode setting
 */
@property (nonatomic,assign) BOOL openNocturnalMode;

@property (nonatomic,assign) BOOL openBPtype;

@property (nonatomic,assign) int protocolVersion;

/**
 Current Mode: Display Device current measurement mode
 Current Mode    Define
 0x00            Usual mode
 0x01            Diagnostic mode
 */
@property (nonatomic,assign) int currentMode;

+ (instancetype)initWithVersionData:(NSString *)data;

+ (instancetype)initWithDeviceInfoData:(NSString *)data;

+ (instancetype)initWithDeviceTimeData:(NSString *)data;

+ (instancetype)initWithNocturnalModeSettingData:(NSString *)data;

+ (instancetype)initWithVersionDataFormWBP:(NSString *)data;
@end
