//
//  MicroLifeDeviceSDK.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2019/5/8.
//  Copyright © 2019 WiFi@MBP. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <CoreBluetooth/CoreBluetooth.h>

//! Project version number for MicroLifeDeviceSDK.
FOUNDATION_EXPORT double MicroLifeDeviceSDKVersionNumber;

//! Project version string for MicroLifeDeviceSDK.
FOUNDATION_EXPORT const unsigned char MicroLifeDeviceSDKVersionString[];

// In this header, you should import all the public headers of your framework using statements like #import <MicroLifeDeviceSDK/PublicHeader.h>

/*!
 *  @enum MicroLifeBLEState
 *
 *  @discussion Represents the current state of a BLE.
 *
 *  @constant MicroLifeBLEStateUnknown=CBManagerStateUnknown       State unknown, update imminent.
 *  @constant MicroLifeBLEStateResetting=CBManagerStateResetting     The connection with the system service was momentarily lost, update imminent.
 *  @constant MicroLifeBLEStateUnsupported=CBManagerStateUnsupported   The platform doesn't support the Bluetooth Low Energy Central/Client role.
 *  @constant MicroLifeBLEStateUnauthorized=CBManagerStateUnauthorized  The application is not authorized to use the Bluetooth Low Energy role.
 *  @constant MicroLifeBLEStatePoweredOff=CBManagerStatePoweredOff    Bluetooth is currently powered off.
 *  @constant MicroLifeBLEStatePoweredOn=CBManagerStatePoweredOn     Bluetooth is currently powered on and available to use.
 *
 */
typedef NS_ENUM(NSInteger, MicroLifeBLEState) {
    MicroLifeBLEStateUnknown = 0,
    MicroLifeBLEStateResetting,
    MicroLifeBLEStateUnsupported,
    MicroLifeBLEStateUnauthorized,
    MicroLifeBLEStatePoweredOff,
    MicroLifeBLEStatePoweredOn,
};

//Device Bluetooth Management from Weight
#import "EBodyBLEManager.h"
//Device Bluetooth Management from BP
#import "BPMBLEManager.h"
//Device Bluetooth Management from Fever
#import "TemperatureBLEManager.h"
//Device Bluetooth Management Form WatchBP
#import "WBPBLEManager.h"

//Cloud API Management
#import "MicroLifeCloudManager.h"
