//
//  MicroLifeUnderblanket.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2018/12/19.
//  Copyright © 2018 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeUnderblanket : NSObject

@property (nonatomic,assign) int heatingStatus;
@property (nonatomic,assign) int heatingLevel;

@property (nonatomic,assign) int mode;
@property (nonatomic,strong) NSString *data1;
@property (nonatomic,strong) NSString *data2;
@property (nonatomic,strong) NSString *data3;
@property (nonatomic,strong) NSString *data4;


@property (nonatomic,strong) NSString *userID;
@property (nonatomic,strong) NSString *firmwareVersion;

+ (instancetype)initWithHeatingStatusData:(NSString *)data;

+ (instancetype)initWithUBSettingsData:(NSString *)data;

+ (instancetype)initWithUserIDAndVersionData:(NSString *)data;

@end

NS_ASSUME_NONNULL_END
