//
//  MicroLifeUserInfo.h
//  MicroLifeDeviceSDK
//
//  Created by WiFi@ on 2018/4/13.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>
/**
 User gender

 - MicroLifeUserGenderMale: Male
 - MicroLifeUserGenderFemale: Female
 */
typedef NS_ENUM(NSInteger, MicroLifeUserGender) {
    MicroLifeUserGenderMale,
    MicroLifeUserGenderFemale,
};

/**
 User's exercise type

 - MicroLifeUserRoleTypeNormal: Normal
 - MicroLifeUserRoleTypeSportsman: Athlete
 */
typedef NS_ENUM(NSInteger, MicroLifeUserRoleType) {
    MicroLifeUserRoleTypeNormal,
    MicroLifeUserRoleTypeSportsman,
};

@interface MicroLifeUserInfo : NSObject

/**
 User No
   Current user, User1 = 1, User2 = 2, Guest = 3
 */
@property (nonatomic,assign) NSInteger userNo;

/**
 User age
   Must be between 18 and 80 years old, otherwise only weight value can be measured
 */
@property (nonatomic,assign) NSUInteger age;

/**
 User height
   Range: 100cm ~ 220cm
   Unit: cm
 */
@property (nonatomic,assign) NSUInteger height;

/**
 User weight (one decimal)
   Range: 20.0kg ~ 150.0kg
   Unit: kg
 */
@property (nonatomic,assign) float weight;

/**
 User gender
 */
@property (nonatomic,assign) MicroLifeUserGender gender;

/**
 User's impedance value
   1. When the user initializes, the resistance uses the default value of 0
   2. Each time the user measures, the user's resistance (using the bodyFat.resistance value in the measurement result) needs to be updated and saved. When the user information is sent again later (for example, the app is restarted), the updated value needs to be updated. Resistance delivered to the scale to get accurate measurement results
  */
@property (nonatomic,assign) NSUInteger resistance;

/**
 User's exercise type
 */
@property (nonatomic,assign) MicroLifeUserRoleType roleType;

/**
 BPMBLEManager ID
   Must be an 9-digit string 2-english string
 */
@property (nonatomic,copy) NSString* BPMuserID;

/**
 EBodyBLEManager ID
   Must be an 11-digit string
   If the user is a guest, the userId should be set to @"00000000000"
 */
@property (nonatomic,copy) NSString* EBodyuserID;

/**
 EBBLEManager ID
   Must be an 5-digit string
 */
@property (nonatomic,copy) NSString* UBuserID;

/**
 BPMBLEManager userInfo

 @param data data
 @param origin origin
 @return userInfo
 */
+ (instancetype)initWithBPMData:(NSString *)data Origin:(int)origin;

@end
