//
//  UserInfo.h
//  EbelterHealth
//
//  Created by belter on 16/9/19.
//  Copyright © 2016年 ebelter. All rights reserved.
//

#import <Foundation/Foundation.h>


typedef enum : NSUInteger {
    UserGenderMale,         // 男性
    UserGenderFemale,       // 女性
} UserGender;

typedef enum : NSUInteger {
    UserRoleTypeNormal,         // 普通类型
    UserRoleTypeSportsman,      // 运动员类型
} UserRoleType;

@interface UserInfo : NSObject<NSCopying>

/**
 用户ID
 必须是11位数字字符串
 如果用户为访客，userId应该设置为 @"00000000000"
 */
@property (nonatomic,copy) NSString* userId;

/**
 用户年龄
 必须在18~80岁之间，否则只能测出体重值
 */
@property (nonatomic,assign) NSUInteger age;

/**
 用户身高
 范围：100cm ~ 220cm
 单位：cm
 */
@property (nonatomic,assign) NSUInteger height;

/**
 用户体重(一位小数)
 范围：20.0kg ~ 150.0kg
 单位：kg
 */
@property (nonatomic,assign) float weight;

/**
 用户性别
 */
@property (nonatomic,assign) UserGender gender;

/**
 用户的阻抗值
 1. 用户初始化时，resistance使用默认值0
 2. 每次该用户测量后，都需要更新用户的resistance（利用测量结果中的 bodyFat.resistance值），并且保存起来，以后再次下发用户信息时（比如app重新启动），需要将更新后的resistance下发到秤，得到准确的测量结果
 
 */
@property (nonatomic,assign) NSUInteger resistance;

/**
 用户的运动类型
 */
@property (nonatomic,assign) UserRoleType roleType;
@end
