//
//  TemperatureBLEManager.h
//  MicroLifeDeviceSDK-Dome
//
//  Created by WiFi@ on 2018/5/18.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MicroLifeDeviceSDK.h"
#import "MicroLifeThermoMeasureData.h"

@protocol TempDataResponseDelegate
#pragma mark - Bluetooth connection section
/**
 Mobile phone Bluetooth status changes
 
 @param state Mobile phone Bluetooth status
 */
- (void)TemperatureBLEManagerCellPhoneBluetoothDidUpdateState:(MicroLifeBLEState)state;

/**
 Search to device
 
 @param macAddress macAddress
 @param name name
 @param RSSI RSSI
 */
- (void)TemperatureBLEManagerDidDiscoverBluetoothDeviceMacAddress:(NSData *)macAddress Name:(NSString *)name RSSI:(NSNumber *)RSSI;

/**
 Device is connected
  */
- (void)TemperatureBLEManagerDidConnectDevice;

/**
 Device connection failed
 */
- (void)TemperatureBLEManagerDidFailToConnectDevice;

/**
 Disconnect
 */
- (void)TemperatureBLEManagerDidDisconnectDevice;

#pragma mark - Received data section
/**
 After Bluetooth connect the thermometer successfully, the first time thermometer send the information initiative

 @param macAddress macAddress description
 @param workMode workMode description
 @param batteryVoltage batteryVoltage description
 */
- (void)TemperatureBLEManagerResponseDeviceInfo:(NSString *)macAddress workMode:(int)workMode batteryVoltage:(float) batteryVoltage;

/**
 Received the current measurement result data

 @param data measurement result data
 */
- (void)TemperatureBLEManagerResponseUploadMeasureData:(MicroLifeThermoMeasureData *)data;
@end

@interface TemperatureBLEManager : NSObject
@property (nonatomic, weak) id<TempDataResponseDelegate> dataResponseDelegate;
@property (nonatomic, strong) MicroLifeDevice *bindingDevice;

@property (nonatomic, strong) NSString *result;
@property (nonatomic, strong) NSString *message;
/**
 Singleton Construction Bluetooth Controller Open equipment:"3MW1","NC150 BT"
 
 @param key Authorization key
 @return Bluetooth Controller
 */
+ (instancetype)shareInstanceWhithAuthorizationkey:(NSString *)key;

/**
 Singleton Construction Bluetooth Controller

 @param key Authorization key
 @param targetTempNames Set the specified display Bluetooth device name
 @return Bluetooth Controller
 */
+ (instancetype)shareInstanceWhithAuthorizationkey:(NSString *)key TargetTempNames:(NSArray *)targetTempNames;

#pragma mark - Send


#pragma mark - Feature
/**
 Get the MAC address of the currently bound scale
 
 @return Mac address, if no device is bound, return nil
 */
- (NSData *)getBindingDevice;

/**
 Binding device
 
 @param macAddress Target device's Mac address
 */
- (void)bindingDevice:(NSData *)macAddress;

/**
   Untie equipment
   */
- (void)unBindingDevice;

#pragma mark - Bluetooth connection
/**
 Re-search for device
 
 */
- (void)reScan;

/**
 Stop searching for device
 */
- (void)stopScan;

/**
   Disconnect Bluetooth from the current device
   */
- (void)disconnectDevice;
@end
