//
//  BodyFat.h
//  HuaweiHealth
//
//  Created by FengJing on 16/12/15.
//  Copyright © 2016年 ebelter. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

typedef enum : NSUInteger {
    EBUnitTypeKG,
    EBUnitTypeLB,
} EBUnitType;

@interface BodyFat : NSObject
/**
 * 测量时间
 */
@property (nonatomic,strong) NSString *time;

/**
 * 测量的成员ID
 */
@property (nonatomic,copy) NSString *userId;

/**
 * 重量单位(kg/lb)
 */
@property (nonatomic,assign) EBUnitType unit;

/**
 * 体重
 * 单位：kg
 */
@property (nonatomic,assign) CGFloat weight;

/**
 * 骨盐量
 * 单位：kg
 */
@property (nonatomic,assign) CGFloat bone;

/**
 * 脂肪率
 * 单位：%
 */
@property (nonatomic,assign) CGFloat adiposerate;

/**
 * 内脏脂肪等级
 */
@property (nonatomic,assign) CGFloat visceralfat;

/**
 * 水分率
 * 单位：%
 */
@property (nonatomic,assign) CGFloat moisture;

/**
 * 基础代谢率
 * 单位：kcal/d
 */
@property (nonatomic,assign) CGFloat bmr;

/**
 * BMI
 */
@property (nonatomic,assign) CGFloat bmi;

/**
 * 身体阻抗
 */
@property (nonatomic,assign) NSUInteger resistance;

/**
 * 蛋白质
 * 单位：%
 */
@property (nonatomic,assign) CGFloat protein;

/**
 * 骨骼肌
 * 单位：kg
 */
@property (nonatomic,assign) CGFloat boneMuscle;

/**
 * 肌肉量
 * 单位：kg
 */
@property (nonatomic,assign) CGFloat muscle;

/**
 * 心率
 * 单位：bpm
 * 没有心率时，返回-1
 */
@property (nonatomic,assign) NSInteger heartRate;
@end
